/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network;

import com.ibm.hwmca.base.settings.SettingsConstants;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.NetworkInfoBean;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.CommonResourceBundle;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.StringUtils;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;

public class IDBean
extends PanelBean
implements SettingsConstants {
    private String m_scomputerName;
    private String m_sDomainName;
    private String m_scomputerDescription;
    private NetworkInfo _networkInfo;
    private static final String TRACE_MASKT = "XSETIDBT";
    private static final String TRACE_MASKF = "XSETIDBF";
    private static final String TRACE_MASKD = "XSETIDBD";
    protected LocalizableText invalidValueMsg = new LocalizableText(CommonResourceBundle.getBundleName(), "formatter.badvalue", null);

    public String getcomputerName() {
        return this.m_scomputerName;
    }

    public void setcomputerName(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "IDBean: setcomputerName run: " + s);
        if (s == null || s.length() == 0 || !StringUtils.isValid(s, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-")) {
            String property = System.getProperty("DEVELOPMENT_SYSTEM");
            if (property != null && property.equals("YES")) {
                if (!StringUtils.isValid(s, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-")) {
                    throw new IllegalUserDataException(this.invalidValueMsg.toString() + "\n[" + s + "]");
                }
            } else {
                throw new IllegalUserDataException(this.invalidValueMsg.toString() + "\n[" + s + "]");
            }
        }
        String platform = this._networkInfo.getPlatform();
        Trace.trace(TRACE_MASKF, "platform = " + platform);
        if (s.length() > 8 && (platform.equals("SE") || platform.equals("ALTSE")) || s.length() > 16 && platform.equals("ZHMC")) {
            throw new IllegalUserDataException(this.invalidValueMsg.toString() + "\n[" + s + "]");
        }
        this.m_scomputerName = s;
    }

    public String getDomainName() {
        return this.m_sDomainName;
    }

    public void setDomainName(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "IDBean: setDomainName run: " + s);
        if (!StringUtils.isValid(s, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.-")) {
            Trace.trace(TRACE_MASKF, "invalidValueMsg.toString() " + this.invalidValueMsg.toString());
            throw new IllegalUserDataException(this.invalidValueMsg.toString() + "\n[" + s + "]");
        }
        this.m_sDomainName = s;
    }

    public String getcomputerDescription() {
        return this.m_scomputerDescription;
    }

    public void setcomputerDescription(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "IDBean: setcomputerDescription run: " + s);
        this.m_scomputerDescription = s;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
    }

    public void panelAction(TaskActionEvent event) {
    }

    public void parentalAction(TaskActionEvent event, PanelBean parent) {
        String command = event.getElementName();
        Trace.trace(TRACE_MASKT, "-> IDBean.parentalAction() : " + command);
        PanelTaskletRequest request = new PanelTaskletRequest("idpanel");
        if (command.endsWith("okButton") || command.endsWith("applyButton")) {
            Trace.trace(TRACE_MASKF, command.substring(command.lastIndexOf(".") + 1) + " pressed! (IDBean) ");
            UserTaskManager utm = (UserTaskManager)event.getSource();
            this.storeMyElements();
            this._networkInfo.setComputerName(this.m_scomputerName);
            this._networkInfo.setDomainName(this.m_sDomainName);
            this._networkInfo.setComputerDescription(this.m_scomputerDescription);
            request.setData("panel", "idpanel");
            request.setData("dataupdates", this._networkInfo);
            this.postTaskletRequest(request);
        } else if (command.endsWith("cancelButton")) {
            Trace.trace(TRACE_MASKF, command.substring(command.lastIndexOf(".") + 1) + " pressed! (IDBean) ");
            UserTaskManager utm = (UserTaskManager)event.getSource();
            this.storeMyElements();
            if (!(this._networkInfo.getComputerName().equals(this.m_scomputerName) && this._networkInfo.getDomainName().equals(this.m_sDomainName) && this._networkInfo.getComputerDescription().equals(this.m_scomputerDescription))) {
                ((NetworkInfoBean)parent).setDataChanged();
                Trace.trace(TRACE_MASKF, "IDBean believes data has changed");
            }
        }
        Trace.trace(TRACE_MASKT, "<- IDBean.parentalAction()");
    }

    public void storeMyElements() {
        Trace.trace(TRACE_MASKT, "-> IDBean.storeMyElements()");
        this.userTaskManager.storeElement(this.getMountPrefix() + "computerName");
        this.userTaskManager.storeElement(this.getMountPrefix() + "domainName");
        this.userTaskManager.storeElement(this.getMountPrefix() + "computerDescription");
        Trace.trace(TRACE_MASKT, "<- IDBean.storeMyElements()");
    }

    public void refreshMyElements() {
        Trace.trace(TRACE_MASKT, "-> IDBean.refreshMyElements()");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "computerName");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "domainName");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "computerDescription");
        Trace.trace(TRACE_MASKT, "<- IDBean.refreshMyElements()");
    }

    public void setNetworkInfo(NetworkInfo networkInfo) {
        Trace.trace(TRACE_MASKT, "-> IDBean.setNetworkInfo()");
        this._networkInfo = networkInfo;
        this.setcomputerName(networkInfo.getComputerName());
        this.setDomainName(networkInfo.getDomainName());
        this.setcomputerDescription(networkInfo.getComputerDescription());
        Trace.trace(TRACE_MASKT, "<- IDBean.setNetworkInfo()");
    }
}

